﻿//******************************************************************************
//Name          : Display.cs
//Description   : Implementation to experience the beauty and the pitfalls of Visualization
//Author        : Dr. Oliver Kluge, 90411 Nuernberg, Germany
//Copyright(C)  : Oliver Kluge 2014 
//------------------------------------------------------------------------------
//******************************************************************************

using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

namespace Display
{
    public partial class DisplayChart : Form
    {
        private Chart m_Chart;
		private Series m_Series;
        private int m_width;
        private int m_heigth;
        private SeriesChartType m_chartype;
        private string m_title;
        private string m_xtitle;
        private string m_ytitle;

        public Chart Chart
        {
            get { return m_Chart; }
        }

        public DisplayChart(int width, int size, SeriesChartType chartype, string title, string x_title, string y_title)
        {
            m_Chart = new Chart();
            m_Series = new Series();

            m_width = width;
            m_heigth = size;
            m_chartype = chartype;
            m_title = title;
            m_xtitle = x_title;
            m_ytitle = y_title;
        
            InitializeComponent();

            //Opacity = 0.75;
            ResizeRedraw = true;
            Resize += new EventHandler(ChartResize);
        }

        private void DisplayChart_Load(object sender, EventArgs e)
        {
            // Create Chart Area
            ChartArea chartArea1 = new ChartArea();

            // Add Chart Area to the Chart
            m_Chart.ChartAreas.Add(chartArea1);

            // Set chart control location
            m_Chart.Location = new Point(0, 0);

            // Set Chart control size
            m_Chart.Size = new Size(m_width, m_heigth);

            // add chart title
            m_Chart.Titles.Add(m_title);
            
            // set some styles of drawing
            m_Chart.Palette = ChartColorPalette.Excel;
            m_Chart.ChartAreas[0].AxisX.MajorGrid.Enabled = false;
            m_Chart.ChartAreas[0].AxisY.MajorGrid.Enabled = false;
            m_Chart.ChartAreas[0].AxisX.Title = m_xtitle;
            m_Chart.ChartAreas[0].AxisY.Title = m_ytitle;
            m_Chart.ChartAreas[0].AxisX.TitleFont = new Font("Courier New", 10f);
            m_Chart.ChartAreas[0].AxisY.TitleFont = new Font("Courier New", 10f);
            m_Chart.ChartAreas[0].AxisY.Crossing = 0;
            m_Chart.ChartAreas[0].AxisX.LabelStyle.Format = "##.###";
            m_Chart.ChartAreas[0].AxisX.LabelStyle.Font = new Font("Courier New", 8f);
            m_Chart.ChartAreas[0].AxisY.LabelStyle.Font = new Font("Courier New", 8f);
            //m_Chart.ChartAreas[0].AxisX.Minimum = 0;
            //m_Chart.ChartAreas[0].AxisX.IsStartedFromZero = true;

            m_Series.ChartType = m_chartype;
            m_Series.BorderWidth = 1;
            m_Series.Color = Color.DarkBlue;
            m_Series.IsVisibleInLegend = false;
            m_Series.IsXValueIndexed = false;

            // add m_Chart to the form
            Controls.AddRange(new Control[] { m_Chart });
        }

        private void ChartResize(object sender, EventArgs e)
        {
            m_Chart.Invalidate();
            //((Control)sender).Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            m_Chart.Width = ClientRectangle.Width;
            m_Chart.Height = ClientRectangle.Height;

            // start/end xAxis with first/last value of x[]
            m_Chart.ChartAreas[0].AxisX.Minimum = m_Series.Points.ElementAt(0).XValue;
            m_Chart.ChartAreas[0].AxisX.Maximum = m_Series.Points.ElementAt(m_Series.Points.Count-1).XValue;
            // set interval
            m_Chart.ChartAreas[0].AxisX.Interval = (m_Chart.ChartAreas[0].AxisX.Maximum + 1 - m_Chart.ChartAreas[0].AxisX.Minimum) / 16;
        }
        
        public void AddData(double[] x, double[] y)
        {
            // add the data points to m_Series
            for (int i = 0; i < x.Length; i++)
            {
                //Chart1.Series[0].Points.AddXY(x[i], y[i]);
                m_Series.Points.AddXY(x[i], y[i]);
            }

            // assign m_Series to m_Chart
            m_Chart.Series.Add(m_Series);
        }
    }
}
